/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MultipartReaction
implements IReaction {
    private final IReaction[] reactions;

    private MultipartReaction(IReaction ... reactions) {
        this.reactions = reactions;
    }

    public static IReaction multi(IReaction ... reactions) {
        return new MultipartReaction(reactions);
    }

    @Override
    public void react(AbstractProjectile projectile, Vector3d impact, World world) {
        for (IReaction reaction : this.reactions) {
            reaction.react(projectile, impact, world);
        }
    }

    @Override
    public void writeInitialData(AbstractProjectile projectile, IAmmoMaterial material, @Nullable LivingEntity owner) {
        for (IReaction reaction : this.reactions) {
            reaction.writeInitialData(projectile, material, owner);
        }
    }
}

